{  Tomasz Stanczak                                                   }
{  Hardenbergstr. 8                                                  }
{  31275 Lehrte                                                      }
{  Germany                                                           }
{                                                                    }
{  CIS ID: 100735,3273                                               }

unit TestUnit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, RtChkLst, ExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    ListBox1: TListBox;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    RtCheckList1: TRtCheckList;
    Label1: TLabel;
    Label2: TLabel;
    RtCheckList2: TRtCheckList;
    RtCheckList3: TRtCheckList;
    Button1: TButton;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup4: TRadioGroup;
    RadioGroup3: TRadioGroup;
    CheckBox1: TCheckBox;
    Bevel1: TBevel;
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RtCheckList1Click(Sender: TObject);
    procedure RtCheckList2Click(Sender: TObject);
    procedure RtCheckList3Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure RtCheckList1Check(Sender: TObject; Index: Integer;
      var Value: Boolean);
    procedure RtCheckList3DrawItem(Sender: TObject; Index: Integer;
      Rect: TRect; State: TOwnerDrawState; var Handled: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure RadioGroup4Click(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button3Click(Sender: TObject);
var
   i: integer;
begin
   for i:=0 to Memo1.Lines.Count-1 do
   begin
      if RtCheckList1.Items.IndexOf(Memo1.Lines[i])<0 then
         RtCheckList1.Items.Add(Memo1.Lines[i]);
      if RtCheckList2.Items.IndexOf(Memo1.Lines[i])<0 then
         RtCheckList2.Items.Add(Memo1.Lines[i]);
      if RtCheckList3.Items.IndexOf(Memo1.Lines[i])<0 then
         RtCheckList3.Items.Add(Memo1.Lines[i]);
   end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
   i,n: integer;
begin
   for i:=0 to Memo1.Lines.Count-1 do
   begin
      n := RtCheckList1.Items.IndexOf(Memo1.Lines[i]);
      if n>=0 then
         RtCheckList1.Items.Delete(n);
      n := RtCheckList2.Items.IndexOf(Memo1.Lines[i]);
      if n>=0 then
         RtCheckList2.Items.Delete(n);
      n := RtCheckList3.Items.IndexOf(Memo1.Lines[i]);
      if n>=0 then
         RtCheckList3.Items.Delete(n);
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
   i: integer;
begin
   for i:=0 to Memo1.Lines.Count-1 do
   begin
      RtCheckList1.Value[Memo1.Lines[i]] := True;
      RtCheckList2.Value[Memo1.Lines[i]] := True;
      RtCheckList3.Value[Memo1.Lines[i]] := True;
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   i: integer;
begin
   for i:=0 to Memo1.Lines.Count-1 do
   begin
      RtCheckList1.Value[Memo1.Lines[i]] := False;
      RtCheckList2.Value[Memo1.Lines[i]] := False;
      RtCheckList3.Value[Memo1.Lines[i]] := False;
   end;
end;

procedure TForm1.RtCheckList1Click(Sender: TObject);
begin
    ListBox1.Items.Assign(RtCheckList1.Checked);
end;

procedure TForm1.RtCheckList2Click(Sender: TObject);
begin
    ListBox1.Items.Assign(RtCheckList2.Checked);
end;

procedure TForm1.RtCheckList3Click(Sender: TObject);
begin
    ListBox1.Items.Assign(RtCheckList3.Checked);
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
   RtCheckList1.CheckMode := TRtCheckMode(TRadioGroup(Sender).ItemIndex);
   RtCheckList2.CheckMode := TRtCheckMode(TRadioGroup(Sender).ItemIndex);
   RtCheckList3.CheckMode := TRtCheckMode(TRadioGroup(Sender).ItemIndex);
end;

procedure TForm1.RtCheckList1Check(Sender: TObject; Index: Integer;
  var Value: Boolean);
var
	Line: string;
begin
	Line := TRtCheckList(Sender).Items[Index]+' will be ';
   if Value then
   	Line := Line+'checked.'
   else
   	Line := Line+'unchecked.';
	if MessageDlg(Line+#13#10+'Proceed ?',mtConfirmation,[mbYes,mbNo],0)=mrNo then
   	Value := not Value;
end;

procedure TForm1.RtCheckList3DrawItem(Sender: TObject; Index: Integer;
  Rect: TRect; State: TOwnerDrawState; var Handled: Boolean);
begin
  	with TRtCheckList(Sender) do
	  	if Value[Items[Index]] then
   		Canvas.Font.Color := clRed;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	Caption :=  Caption+FormatFloat(' ##.##',RtChkLst.Version);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
   RtCheckList1.WordWrap := (Sender as TCheckBox).Checked;
   RtCheckList2.WordWrap := (Sender as TCheckBox).Checked;
   RtCheckList3.WordWrap := (Sender as TCheckBox).Checked;
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
   RtCheckList1.TextAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
   RtCheckList2.TextAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
   RtCheckList3.TextAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
end;

procedure TForm1.RadioGroup4Click(Sender: TObject);
begin
   RtCheckList1.BmpVAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex+2);
   RtCheckList2.BmpVAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex+2);
   RtCheckList3.BmpVAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex+2);
end;

procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
   RtCheckList1.BmpHAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
   RtCheckList2.BmpHAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
   RtCheckList3.BmpHAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
end;

end.
